
// Mandelbrot01Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Mandelbrot01.h"
#include "Mandelbrot01Dlg.h"
#include "oblicz.h"
#include "omp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMandelbrot01Dlg dialog


CMandelbrot01Dlg::CMandelbrot01Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMandelbrot01Dlg::IDD, pParent)
	, kolor(0)
	, LiczbaKlikniec(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMandelbrot01Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PICTURECONTROL, picture1);
	DDX_Control(pDX, IDC_EDIT1, edtLW);
	DDX_Control(pDX, IDC_BUTTON1, btnOblicz);
	DDX_Control(pDX, IDC_TXTCWS, txtCWS);
	DDX_Control(pDX, IDC_TXTCWW, txtCWW);
	DDX_Control(pDX, IDC_TXTSP, txtSP);
	DDX_Control(pDX, IDC_BUTTON2, btnSekcje);
}

BEGIN_MESSAGE_MAP(CMandelbrot01Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CMandelbrot01Dlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CMandelbrot01Dlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CMandelbrot01Dlg message handlers

BOOL CMandelbrot01Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	LiczbaKlikniec = 0;
	
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	CString lwstr;
	lwstr.Format(_T("%d"), 1);
	edtLW.SetWindowTextW(lwstr);

	kolor = new unsigned int[RX*RY];
	::SetWindowPos(m_hWnd , NULL, 0, 0, RX+30, RY+109, SWP_NOMOVE);
	::SetWindowPos(picture1 , NULL, 0, 0, RX, RY, SWP_NOMOVE);


	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	int LiczbaWatkow;
	LiczbaWatkow=omp_get_num_procs(); 
	lwstr.Format(_T("%d"),LiczbaWatkow);
	edtLW.SetWindowTextW(lwstr);
	OnBnClickedButton1();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMandelbrot01Dlg::OnPaint()
{
	CString str;
	double StartPP = omp_get_wtime();
	rysujBMP(kolor);
	double KoniecPP = omp_get_wtime();
	str.Format(_T("Czas odwieania: %2.4f"),KoniecPP-StartPP);
	txtSP.SetWindowTextW(str);
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMandelbrot01Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CMandelbrot01Dlg::OnBnClickedButton1()
{
	double powierzchnia;

	btnOblicz.SetWindowTextW(_T("Licz"));
	LiczbaKlikniec++;
	CString str;
	edtLW.GetWindowTextW(str);
	int LiczbaWatkow=_ttoi(str);

	double StartP = omp_get_wtime();
	oblicz(kolor, RX, RY, LiczbaWatkow, CX0, CY0, SX, SY, NP);
	double KoniecP = omp_get_wtime();
	str.Format(_T("Czas wyk. rwnolegego: %2.3f"),KoniecP-StartP);
	txtCWW.SetWindowTextW(str);

	powierzchnia = Powierchnia2(kolor, RX, RY, LiczbaWatkow, SX, SY);
	str.Format(_T("Pole pow. zbioru mandelbrota: %2.3f"),powierzchnia);
	txtCWS.SetWindowTextW(str);
	str.Format(_T("Nie wykorzystana ..."));
	txtSP.SetWindowTextW(str);
	btnOblicz.SetWindowTextW(_T("Oblicz"));

	rysujBMP(kolor);

}

void CMandelbrot01Dlg::rysujBMP(unsigned int* kolor)
{
	picture1.Invalidate();
	CPaintDC dc(&picture1); 
	CRect rect;
	picture1.GetWindowRect(rect);
	int dx = rect.Width(); 
	int dy = rect.Height();
	CDC memDC;
	memDC.CreateCompatibleDC(&dc);
    CBitmap bmp;
	bmp.CreateCompatibleBitmap(&dc, dx, dy);
	CBitmap* pstaryBmp = memDC.SelectObject(&bmp);
	int zk = LiczbaKlikniec % 10;
	for (int ix=0;ix<dx;++ix)
		for (int iy=0;iy<dy;++iy)
		{
			int idx = kolor[iy*dx+ix];
			memDC.SetPixel(ix,iy,RGB(idx*(50+2*zk),idx*(25+zk),idx));
		}
	dc.BitBlt(0, 0, dx, dy, &memDC, 0, 0, SRCCOPY);
	memDC.SelectObject(pstaryBmp);
	bmp.DeleteObject();
	memDC.DeleteDC();
}

void CMandelbrot01Dlg::OnBnClickedButton2()
{
	CString str;
	int LiczbaWatkow;
	btnSekcje.SetWindowTextW(_T("Licz"));
	LiczbaKlikniec++;
	edtLW.GetWindowTextW(str);
	LiczbaWatkow=_ttoi(str);
	
	CString strCWS, strCWW, strSP;
	unsigned int * brzeg;
	brzeg = new unsigned int[RX*RY];
	for (int ib =0; ib<RX*RY;ib++) brzeg[ib]=0;
	double StartP = omp_get_wtime();
	Sekcje(brzeg, kolor, RX, RY, LiczbaWatkow, CX0, CY0, SX, SY, strCWS, strCWW, strSP);
	int id=strCWS.Find(_T(";"));
	double KoniecP = omp_get_wtime();
	txtCWW.SetWindowTextW(strCWW);
	txtCWS.SetWindowTextW(strCWS);
	
	
	double StartPP = omp_get_wtime();
	rysujBMP(brzeg);
	double KoniecPP = omp_get_wtime();
	txtSP.SetWindowTextW(strSP);
	btnSekcje.SetWindowTextW(_T("Sekcje"));
}
